package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RecyclingSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♻️",
        description = "recycling symbol",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("recycling-symbol", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: recycling symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RecyclingSymbol: Emoji get() = _RecyclingSymbol
