package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoLittering: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚯",
        description = "no littering",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("no-littering", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: warning: no littering.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoLittering: Emoji get() = _NoLittering
