package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Brick: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧱",
        description = "brick",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("brick", "bricks"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: place-building: brick.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Brick: Emoji get() = _Brick

/**
 * Alias to emoji [Brick] (Travel & Places: place-building: brick).
*/
public val Emoji.Companion.Bricks: Emoji get() = _Brick
