package org.kodein.emoji.travel_places.place_geographic

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SnowCappedMountain: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏔️",
        description = "snow-capped mountain",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("snow-capped-mountain", "snow-mountain"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: place-geographic: snow-capped mountain.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SnowCappedMountain: Emoji get() = _SnowCappedMountain

/**
 * Alias to emoji [SnowCappedMountain] (Travel & Places: place-geographic: snow-capped mountain).
*/
public val Emoji.Companion.SnowMountain: Emoji get() = _SnowCappedMountain
