package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GlobeShowingEuropeAfrica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌍",
        description = "globe showing Europe-Africa",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("globe-showing-europe-africa", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: place-map: globe showing Europe-Africa.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GlobeShowingEuropeAfrica: Emoji get() = _GlobeShowingEuropeAfrica
