package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrystalBall: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔮",
        description = "crystal ball",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("crystal-ball", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: crystal ball.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrystalBall: Emoji get() = _CrystalBall
