package org.kodein.emoji.animals_nature.animal_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalMarine() {
    add(intArrayOf(0x1f433), _SpoutingWhale)
    add(intArrayOf(0x1f40b), _Whale)
    add(intArrayOf(0x1f42c), _Dolphin)
    add(intArrayOf(0x1f9ad), _Seal)
    add(intArrayOf(0x1f41f), _Fish)
    add(intArrayOf(0x1f420), _TropicalFish)
    add(intArrayOf(0x1f421), _Blowfish)
    add(intArrayOf(0x1f988), _Shark)
    add(intArrayOf(0x1f419), _Octopus)
    add(intArrayOf(0x1f41a), _SpiralShell)
    add(intArrayOf(0x1fab8), _Coral)
    add(intArrayOf(0x1fabc), _Jellyfish)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalMarine() {
    yield(_SpoutingWhale)
    yield(_Whale)
    yield(_Dolphin)
    yield(_Seal)
    yield(_Fish)
    yield(_TropicalFish)
    yield(_Blowfish)
    yield(_Shark)
    yield(_Octopus)
    yield(_SpiralShell)
    yield(_Coral)
    yield(_Jellyfish)
}

internal val countAnimalMarine = 12

/**
 * All Emoji of the Animals & Nature: animal-marine subgroup.
*/
public fun Emoji.Companion.sequenceAnimalMarine(): Sequence<Emoji> =
    sequence { yieldAllAnimalMarine() }

/**
 * All Emoji of the Animals & Nature: animal-marine subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAnimalMarine(): List<Emoji> =
    ArrayList<Emoji>(countAnimalMarine).also { list -> sequenceAnimalMarine().forEach { list.add(it) } }

@Deprecated("Renamed listAnimalMarine.", replaceWith = ReplaceWith("listAnimalMarine()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAnimalMarine(): List<Emoji> =
    listAnimalMarine()
