package org.kodein.emoji.animals_nature.animal_reptile

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalReptile() {
    add(intArrayOf(0x1f40a), _Crocodile)
    add(intArrayOf(0x1f422), _Turtle)
    add(intArrayOf(0x1f98e), _Lizard)
    add(intArrayOf(0x1f40d), _Snake)
    add(intArrayOf(0x1f432), _DragonFace)
    add(intArrayOf(0x1f409), _Dragon)
    add(intArrayOf(0x1f995), _Sauropod)
    add(intArrayOf(0x1f996), _TRex)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalReptile() {
    yield(_Crocodile)
    yield(_Turtle)
    yield(_Lizard)
    yield(_Snake)
    yield(_DragonFace)
    yield(_Dragon)
    yield(_Sauropod)
    yield(_TRex)
}

internal val countAnimalReptile = 8

/**
 * All Emoji of the Animals & Nature: animal-reptile subgroup.
*/
public fun Emoji.Companion.sequenceAnimalReptile(): Sequence<Emoji> =
    sequence { yieldAllAnimalReptile() }

/**
 * All Emoji of the Animals & Nature: animal-reptile subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAnimalReptile(): List<Emoji> =
    ArrayList<Emoji>(countAnimalReptile).also { list -> sequenceAnimalReptile().forEach { list.add(it) } }

@Deprecated("Renamed listAnimalReptile.", replaceWith = ReplaceWith("listAnimalReptile()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAnimalReptile(): List<Emoji> =
    listAnimalReptile()
