package org.kodein.emoji.animals_nature.plant_flower

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WiltedFlower: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥀",
        description = "wilted flower",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("wilted-flower", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Animals & Nature: plant-flower: wilted flower.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WiltedFlower: Emoji get() = _WiltedFlower
