package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLesotho: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇸",
        description = "flag: Lesotho",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-lesotho", "lesotho-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Lesotho.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLesotho: Emoji get() = _FlagLesotho

/**
 * Alias to emoji [FlagLesotho] (Flags: country-flag: flag: Lesotho).
*/
public val Emoji.Companion.LesothoFlag: Emoji get() = _FlagLesotho
