package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTokelau: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇰",
        description = "flag: Tokelau",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tokelau", "tokelau-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tokelau.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTokelau: Emoji get() = _FlagTokelau

/**
 * Alias to emoji [FlagTokelau] (Flags: country-flag: flag: Tokelau).
*/
public val Emoji.Companion.TokelauFlag: Emoji get() = _FlagTokelau
