package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UnamusedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😒",
        description = "unamused face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("unamused-face", "unamused"),
        emoticons = listOf(">->"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: unamused face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UnamusedFace: Emoji get() = _UnamusedFace

/**
 * Alias to emoji [UnamusedFace] (Smileys & Emotion: face-neutral-skeptical: unamused face).
*/
public val Emoji.Companion.Unamused: Emoji get() = _UnamusedFace
