package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Aquarius: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♒",
        description = "Aquarius",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("aquarius", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Aquarius.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Aquarius: Emoji get() = _Aquarius
