package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Snowflake: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❄️",
        description = "snowflake",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("snowflake", "winter", "cold"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: snowflake.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Snowflake: Emoji get() = _Snowflake

/**
 * Alias to emoji [Snowflake] (Travel & Places: sky & weather: snowflake).
*/
public val Emoji.Companion.Winter: Emoji get() = _Snowflake

/**
 * Alias to emoji [Snowflake] (Travel & Places: sky & weather: snowflake).
*/
public val Emoji.Companion.Cold: Emoji get() = _Snowflake
