package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTonga: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇴",
        description = "flag: Tonga",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tonga", "tonga-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tonga.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTonga: Emoji get() = _FlagTonga

/**
 * Alias to emoji [FlagTonga] (Flags: country-flag: flag: Tonga).
*/
public val Emoji.Companion.TongaFlag: Emoji get() = _FlagTonga
