package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUSVirginIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇮",
        description = "flag: U.S. Virgin Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-u-s-virgin-islands", "us-virgin-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: U.S. Virgin Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUSVirginIslands: Emoji get() = _FlagUSVirginIslands

/**
 * Alias to emoji [FlagUSVirginIslands] (Flags: country-flag: flag: U.S. Virgin Islands).
*/
public val Emoji.Companion.UsVirginIslandsFlag: Emoji get() = _FlagUSVirginIslands
