package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonGesturingOk: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙆",
        description = "person gesturing OK",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-gesturing-ok", "gesture-ok"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person gesturing OK.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonGesturingOk: SkinTone1Emoji get() = _PersonGesturingOk

/**
 * Alias to emoji [PersonGesturingOk] (People & Body: person-gesture: person gesturing OK).
*/
public val Emoji.Companion.GestureOk: SkinTone1Emoji get() = _PersonGesturingOk
