package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DashingAway: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💨",
        description = "dashing away",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("dashing-away", "dash", "poof"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: dashing away.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DashingAway: Emoji get() = _DashingAway

/**
 * Alias to emoji [DashingAway] (Smileys & Emotion: emotion: dashing away).
*/
public val Emoji.Companion.Dash: Emoji get() = _DashingAway

/**
 * Alias to emoji [DashingAway] (Smileys & Emotion: emotion: dashing away).
*/
public val Emoji.Companion.Poof: Emoji get() = _DashingAway
