package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceSmiling() {
    add(intArrayOf(0x1f600), _GrinningFace)
    add(intArrayOf(0x1f603), _GrinningFaceWithBigEyes)
    add(intArrayOf(0x1f604), _GrinningFaceWithSmilingEyes)
    add(intArrayOf(0x1f601), _BeamingFaceWithSmilingEyes)
    add(intArrayOf(0x1f606), _GrinningSquintingFace)
    add(intArrayOf(0x1f605), _GrinningFaceWithSweat)
    add(intArrayOf(0x1f602), _FaceWithTearsOfJoy)
    add(intArrayOf(0x1f923), _RollingOnTheFloorLaughing)
    add(intArrayOf(0x1f609), _WinkingFace)
    add(intArrayOf(0x1fae0), _MeltingFace)
    add(intArrayOf(0x1f643), _UpsideDownFace)
    add(intArrayOf(0x1f642), _SlightlySmilingFace)
    add(intArrayOf(0x1f60a), _SmilingFaceWithSmilingEyes)
    add(intArrayOf(0x1f607), _SmilingFaceWithHalo)
}

internal fun MutableList<Emoji>.addAllFaceSmiling() {
    add(_GrinningFace)
    add(_GrinningFaceWithBigEyes)
    add(_GrinningFaceWithSmilingEyes)
    add(_BeamingFaceWithSmilingEyes)
    add(_GrinningSquintingFace)
    add(_GrinningFaceWithSweat)
    add(_FaceWithTearsOfJoy)
    add(_RollingOnTheFloorLaughing)
    add(_WinkingFace)
    add(_MeltingFace)
    add(_UpsideDownFace)
    add(_SlightlySmilingFace)
    add(_SmilingFaceWithSmilingEyes)
    add(_SmilingFaceWithHalo)
}

/**
 * All Emoji of the Smileys & Emotion: face-smiling subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceSmiling(): List<Emoji> =
    ArrayList<Emoji>(14).apply { addAllFaceSmiling() }
