package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _YellowSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟨",
        description = "yellow square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("yellow-square", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: yellow square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.YellowSquare: Emoji get() = _YellowSquare
