package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoPedestrians: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚷",
        description = "no pedestrians",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("no-pedestrians", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: warning: no pedestrians.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoPedestrians: Emoji get() = _NoPedestrians
