package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FirstQuarterMoonFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌛",
        description = "first quarter moon face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("first-quarter-moon-face", "moon-face-first-quarter"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: first quarter moon face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FirstQuarterMoonFace: Emoji get() = _FirstQuarterMoonFace

/**
 * Alias to emoji [FirstQuarterMoonFace] (Travel & Places: sky & weather: first quarter moon face).
*/
public val Emoji.Companion.MoonFaceFirstQuarter: Emoji get() = _FirstQuarterMoonFace
