package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ManualWheelchair: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦽",
        description = "manual wheelchair",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("manual-wheelchair", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: manual wheelchair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ManualWheelchair: Emoji get() = _ManualWheelchair
