package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIsrael: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇱",
        description = "flag: Israel",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-israel", "israel-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Israel.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIsrael: Emoji get() = _FlagIsrael

/**
 * Alias to emoji [FlagIsrael] (Flags: country-flag: flag: Israel).
*/
public val Emoji.Companion.IsraelFlag: Emoji get() = _FlagIsrael
