package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUSOutlyingIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇲",
        description = "flag: U.S. Outlying Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-u-s-outlying-islands", "us-outlying-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: U.S. Outlying Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUSOutlyingIslands: Emoji get() = _FlagUSOutlyingIslands

/**
 * Alias to emoji [FlagUSOutlyingIslands] (Flags: country-flag: flag: U.S. Outlying Islands).
*/
public val Emoji.Companion.UsOutlyingIslandsFlag: Emoji get() = _FlagUSOutlyingIslands
