package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUganda: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇬",
        description = "flag: Uganda",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-uganda", "uganda-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Uganda.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUganda: Emoji get() = _FlagUganda

/**
 * Alias to emoji [FlagUganda] (Flags: country-flag: flag: Uganda).
*/
public val Emoji.Companion.UgandaFlag: Emoji get() = _FlagUganda
