package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BubbleTea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧋",
        description = "bubble tea",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("bubble-tea", "milk-tea"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Food & Drink: drink: bubble tea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BubbleTea: Emoji get() = _BubbleTea

/**
 * Alias to emoji [BubbleTea] (Food & Drink: drink: bubble tea).
*/
public val Emoji.Companion.MilkTea: Emoji get() = _BubbleTea
