package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MansShoe: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👞",
        description = "man’s shoe",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("mans-shoe", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: man’s shoe.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MansShoe: Emoji get() = _MansShoe
