package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTool() {
    add(intArrayOf(0x1f3f9), _BowAndArrow)
    add(intArrayOf(0x1fa83), _Boomerang)
    add(intArrayOf(0x2696, 0xfe0f), _BalanceScale)
    add(intArrayOf(0x2696), _BalanceScale)
    add(intArrayOf(0x1f9af), _WhiteCane)
    add(intArrayOf(0x1fa93), _Axe)
    add(intArrayOf(0x1fa9c), _Ladder)
    add(intArrayOf(0x1fa9d), _Hook)
    add(intArrayOf(0x1f9f2), _Magnet)
    add(intArrayOf(0x1f9f0), _Toolbox)
    add(intArrayOf(0x1f5dc, 0xfe0f), _Clamp)
    add(intArrayOf(0x1f5dc), _Clamp)
    add(intArrayOf(0x1f529), _NutAndBolt)
    add(intArrayOf(0x1fa9b), _Screwdriver)
    add(intArrayOf(0x1fa9a), _CarpentrySaw)
    add(intArrayOf(0x1f527), _Wrench)
    add(intArrayOf(0x1f528), _Hammer)
    add(intArrayOf(0x2692, 0xfe0f), _HammerAndPick)
    add(intArrayOf(0x2692), _HammerAndPick)
    add(intArrayOf(0x1f6e0, 0xfe0f), _HammerAndWrench)
    add(intArrayOf(0x1f6e0), _HammerAndWrench)
    add(intArrayOf(0x26cf, 0xfe0f), _Pick)
    add(intArrayOf(0x26cf), _Pick)
    add(intArrayOf(0x2699, 0xfe0f), _Gear)
    add(intArrayOf(0x2699), _Gear)
    add(intArrayOf(0x1f517), _Link)
    add(intArrayOf(0x26d3, 0xfe0f), _Chains)
    add(intArrayOf(0x26d3), _Chains)
    add(intArrayOf(0x1f4a3), _Bomb)
    add(intArrayOf(0x2694, 0xfe0f), _CrossedSwords)
    add(intArrayOf(0x2694), _CrossedSwords)
    add(intArrayOf(0x1f5e1, 0xfe0f), _Dagger)
    add(intArrayOf(0x1f5e1), _Dagger)
    add(intArrayOf(0x1f6e1, 0xfe0f), _Shield)
    add(intArrayOf(0x1f6e1), _Shield)
    add(intArrayOf(0x26d3, 0xfe0f, 0x200d, 0x1f4a5), _BrokenChain)
    add(intArrayOf(0x26d3, 0x200d, 0x1f4a5), _BrokenChain)
}

internal fun MutableList<Emoji>.addAllTool() {
    add(_BowAndArrow)
    add(_Boomerang)
    add(_BalanceScale)
    add(_WhiteCane)
    add(_Axe)
    add(_Ladder)
    add(_Hook)
    add(_Magnet)
    add(_Toolbox)
    add(_Clamp)
    add(_NutAndBolt)
    add(_Screwdriver)
    add(_CarpentrySaw)
    add(_Wrench)
    add(_Hammer)
    add(_HammerAndPick)
    add(_HammerAndWrench)
    add(_Pick)
    add(_Gear)
    add(_Link)
    add(_Chains)
    add(_Bomb)
    add(_CrossedSwords)
    add(_Dagger)
    add(_Shield)
    add(_BrokenChain)
}

/**
 * All Emoji of the Objects: tool subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTool(): List<Emoji> =
    ArrayList<Emoji>(26).apply { addAllTool() }
