package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FrowningFaceWithOpenMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😦",
        description = "frowning face with open mouth",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("frowning-face-with-open-mouth", "gasp"),
        emoticons = listOf("D="),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: frowning face with open mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FrowningFaceWithOpenMouth: Emoji get() = _FrowningFaceWithOpenMouth

/**
 * Alias to emoji [FrowningFaceWithOpenMouth] (Smileys & Emotion: face-concerned: frowning face with open mouth).
*/
public val Emoji.Companion.Gasp: Emoji get() = _FrowningFaceWithOpenMouth
