package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceNeutralSkeptical() {
    add(intArrayOf(0x1f60f), _SmirkingFace)
    add(intArrayOf(0x1f62c), _GrimacingFace)
    add(intArrayOf(0x1f611), _ExpressionlessFace)
    add(intArrayOf(0x1f610), _NeutralFace)
    add(intArrayOf(0x1f636), _FaceWithoutMouth)
    add(intArrayOf(0x1f636, 0x200d, 0x1f32b, 0xfe0f), _FaceInClouds)
    add(intArrayOf(0x1f636, 0x200d, 0x1f32b), _FaceInClouds)
    add(intArrayOf(0x1fae5), _DottedLineFace)
    add(intArrayOf(0x1f910), _ZipperMouthFace)
    add(intArrayOf(0x1f928), _FaceWithRaisedEyebrow)
    add(intArrayOf(0x1f612), _UnamusedFace)
    add(intArrayOf(0x1f644), _FaceWithRollingEyes)
    add(intArrayOf(0x1f62e, 0x200d, 0x1f4a8), _FaceExhaling)
    add(intArrayOf(0x1fae8), _ShakingFace)
    add(intArrayOf(0x1f925), _LyingFace)
    add(intArrayOf(0x1f642, 0x200d, 0x2194), _HeadShakingHorizontally)
    add(intArrayOf(0x1f642, 0x200d, 0x2194, 0xfe0f), _HeadShakingHorizontally)
    add(intArrayOf(0x1f642, 0x200d, 0x2195), _HeadShakingVertically)
    add(intArrayOf(0x1f642, 0x200d, 0x2195, 0xfe0f), _HeadShakingVertically)
}

internal fun MutableList<Emoji>.addAllFaceNeutralSkeptical() {
    add(_SmirkingFace)
    add(_GrimacingFace)
    add(_ExpressionlessFace)
    add(_NeutralFace)
    add(_FaceWithoutMouth)
    add(_FaceInClouds)
    add(_DottedLineFace)
    add(_ZipperMouthFace)
    add(_FaceWithRaisedEyebrow)
    add(_UnamusedFace)
    add(_FaceWithRollingEyes)
    add(_FaceExhaling)
    add(_ShakingFace)
    add(_LyingFace)
    add(_HeadShakingHorizontally)
    add(_HeadShakingVertically)
}

/**
 * All Emoji of the Smileys & Emotion: face-neutral-skeptical subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceNeutralSkeptical(): List<Emoji> =
    ArrayList<Emoji>(16).apply { addAllFaceNeutralSkeptical() }
