package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AtmSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏧",
        description = "ATM sign",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("atm-sign", "atm"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: ATM sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AtmSign: Emoji get() = _AtmSign

/**
 * Alias to emoji [AtmSign] (Symbols: transport-sign: ATM sign).
*/
public val Emoji.Companion.Atm: Emoji get() = _AtmSign
