package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Virgo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♍",
        description = "Virgo",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("virgo", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Symbols: zodiac: Virgo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Virgo: Emoji get() = _Virgo
