package org.kodein.emoji.travel_places

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.travel_places.place_geographic.*
import org.kodein.emoji.travel_places.place_map.*
import org.kodein.emoji.travel_places.sky_weather.*
import org.kodein.emoji.travel_places.place_building.*
import org.kodein.emoji.travel_places.transport_water.*
import org.kodein.emoji.travel_places.place_other.*
import org.kodein.emoji.travel_places.transport_air.*
import org.kodein.emoji.travel_places.hotel.*
import org.kodein.emoji.travel_places.transport_ground.*
import org.kodein.emoji.travel_places.time.*
import org.kodein.emoji.travel_places.place_religious.*


internal fun EmojiFinder.addAllTravelPlaces() {
    addAllPlaceGeographic()
    addAllPlaceMap()
    addAllSkyWeather()
    addAllPlaceBuilding()
    addAllTransportWater()
    addAllPlaceOther()
    addAllTransportAir()
    addAllHotel()
    addAllTransportGround()
    addAllTime()
    addAllPlaceReligious()
}

internal fun MutableList<Emoji>.addAllTravelPlaces() {
    addAllPlaceGeographic()
    addAllPlaceMap()
    addAllSkyWeather()
    addAllPlaceBuilding()
    addAllTransportWater()
    addAllPlaceOther()
    addAllTransportAir()
    addAllHotel()
    addAllTransportGround()
    addAllTime()
    addAllPlaceReligious()
}

/**
 * All Emoji of the Travel & Places group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTravelPlaces(): List<Emoji> =
    ArrayList<Emoji>(218).apply { addAllTravelPlaces() }

internal fun allTravelPlacesSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "place_geographic" to { Emoji.allPlaceGeographic() },
        "place_map" to { Emoji.allPlaceMap() },
        "sky_weather" to { Emoji.allSkyWeather() },
        "place_building" to { Emoji.allPlaceBuilding() },
        "transport_water" to { Emoji.allTransportWater() },
        "place_other" to { Emoji.allPlaceOther() },
        "transport_air" to { Emoji.allTransportAir() },
        "hotel" to { Emoji.allHotel() },
        "transport_ground" to { Emoji.allTransportGround() },
        "time" to { Emoji.allTime() },
        "place_religious" to { Emoji.allPlaceReligious() },
    )
