package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MotorizedWheelchair: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦼",
        description = "motorized wheelchair",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("motorized-wheelchair", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: motorized wheelchair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MotorizedWheelchair: Emoji get() = _MotorizedWheelchair
