package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _VerticalTrafficLight: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚦",
        description = "vertical traffic light",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("vertical-traffic-light", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: vertical traffic light.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VerticalTrafficLight: Emoji get() = _VerticalTrafficLight
