package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagArmenia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇲",
        description = "flag: Armenia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-armenia", "armenia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Armenia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagArmenia: Emoji get() = _FlagArmenia

/**
 * Alias to emoji [FlagArmenia] (Flags: country-flag: flag: Armenia).
*/
public val Emoji.Companion.ArmeniaFlag: Emoji get() = _FlagArmenia
