package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBouvetIsland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇻",
        description = "flag: Bouvet Island",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bouvet-island", "bouvet-island-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bouvet Island.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBouvetIsland: Emoji get() = _FlagBouvetIsland

/**
 * Alias to emoji [FlagBouvetIsland] (Flags: country-flag: flag: Bouvet Island).
*/
public val Emoji.Companion.BouvetIslandFlag: Emoji get() = _FlagBouvetIsland
