package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBritishIndianOceanTerritory: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇴",
        description = "flag: British Indian Ocean Territory",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-british-indian-ocean-territory", "british-indian-ocean-territory-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: British Indian Ocean Territory.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBritishIndianOceanTerritory: Emoji get() = _FlagBritishIndianOceanTerritory

/**
 * Alias to emoji [FlagBritishIndianOceanTerritory] (Flags: country-flag: flag: British Indian Ocean Territory).
*/
public val Emoji.Companion.BritishIndianOceanTerritoryFlag: Emoji get() = _FlagBritishIndianOceanTerritory
