package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagChristmasIsland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇽",
        description = "flag: Christmas Island",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-christmas-island", "christmas-island-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Christmas Island.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagChristmasIsland: Emoji get() = _FlagChristmasIsland

/**
 * Alias to emoji [FlagChristmasIsland] (Flags: country-flag: flag: Christmas Island).
*/
public val Emoji.Companion.ChristmasIslandFlag: Emoji get() = _FlagChristmasIsland
