package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMoldova: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇩",
        description = "flag: Moldova",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-moldova", "moldova-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Moldova.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMoldova: Emoji get() = _FlagMoldova

/**
 * Alias to emoji [FlagMoldova] (Flags: country-flag: flag: Moldova).
*/
public val Emoji.Companion.MoldovaFlag: Emoji get() = _FlagMoldova
