package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllSound() {
    add(intArrayOf(0x1f4e2), _Loudspeaker)
    add(intArrayOf(0x1f514), _Bell)
    add(intArrayOf(0x1f4ef), _PostalHorn)
    add(intArrayOf(0x1f4e3), _Megaphone)
    add(intArrayOf(0x1f515), _BellWithSlash)
    add(intArrayOf(0x1f507), _MutedSpeaker)
    add(intArrayOf(0x1f508), _SpeakerLowVolume)
    add(intArrayOf(0x1f509), _SpeakerMediumVolume)
    add(intArrayOf(0x1f50a), _SpeakerHighVolume)
}

internal fun MutableList<Emoji>.addAllSound() {
    add(_Loudspeaker)
    add(_Bell)
    add(_PostalHorn)
    add(_Megaphone)
    add(_BellWithSlash)
    add(_MutedSpeaker)
    add(_SpeakerLowVolume)
    add(_SpeakerMediumVolume)
    add(_SpeakerHighVolume)
}

/**
 * All Emoji of the Objects: sound subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allSound(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllSound() }
