package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonGesturingNo: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙅",
        description = "person gesturing NO",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-gesturing-no", "no-gesture", "no-good", "denied", "halt"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person gesturing NO.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonGesturingNo: SkinTone1Emoji get() = _PersonGesturingNo

/**
 * Alias to emoji [PersonGesturingNo] (People & Body: person-gesture: person gesturing NO).
*/
public val Emoji.Companion.NoGesture: SkinTone1Emoji get() = _PersonGesturingNo

/**
 * Alias to emoji [PersonGesturingNo] (People & Body: person-gesture: person gesturing NO).
*/
public val Emoji.Companion.NoGood: SkinTone1Emoji get() = _PersonGesturingNo

/**
 * Alias to emoji [PersonGesturingNo] (People & Body: person-gesture: person gesturing NO).
*/
public val Emoji.Companion.Denied: SkinTone1Emoji get() = _PersonGesturingNo

/**
 * Alias to emoji [PersonGesturingNo] (People & Body: person-gesture: person gesturing NO).
*/
public val Emoji.Companion.Halt: SkinTone1Emoji get() = _PersonGesturingNo
