package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PensiveFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😔",
        description = "pensive face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("pensive-face", "pensive"),
        emoticons = listOf("._."),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: pensive face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PensiveFace: Emoji get() = _PensiveFace

/**
 * Alias to emoji [PensiveFace] (Smileys & Emotion: face-sleepy: pensive face).
*/
public val Emoji.Companion.Pensive: Emoji get() = _PensiveFace
