package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OrangeHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧡",
        description = "orange heart",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("orange-heart", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: orange heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OrangeHeart: Emoji get() = _OrangeHeart
