package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RightArrowCurvingDown: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⤵️",
        description = "right arrow curving down",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("right-arrow-curving-down", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: right arrow curving down.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightArrowCurvingDown: Emoji get() = _RightArrowCurvingDown
