package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBurundi: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇮",
        description = "flag: Burundi",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-burundi", "burundi-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Burundi.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBurundi: Emoji get() = _FlagBurundi

/**
 * Alias to emoji [FlagBurundi] (Flags: country-flag: flag: Burundi).
*/
public val Emoji.Companion.BurundiFlag: Emoji get() = _FlagBurundi
