package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagDominica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇲",
        description = "flag: Dominica",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-dominica", "dominica-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Dominica.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagDominica: Emoji get() = _FlagDominica

/**
 * Alias to emoji [FlagDominica] (Flags: country-flag: flag: Dominica).
*/
public val Emoji.Companion.DominicaFlag: Emoji get() = _FlagDominica
