package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEritrea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇷",
        description = "flag: Eritrea",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-eritrea", "eritrea-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Eritrea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEritrea: Emoji get() = _FlagEritrea

/**
 * Alias to emoji [FlagEritrea] (Flags: country-flag: flag: Eritrea).
*/
public val Emoji.Companion.EritreaFlag: Emoji get() = _FlagEritrea
