package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPuertoRico: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇷",
        description = "flag: Puerto Rico",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-puerto-rico", "puerto-rico-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Puerto Rico.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPuertoRico: Emoji get() = _FlagPuertoRico

/**
 * Alias to emoji [FlagPuertoRico] (Flags: country-flag: flag: Puerto Rico).
*/
public val Emoji.Companion.PuertoRicoFlag: Emoji get() = _FlagPuertoRico
